VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} AdjustSKDims 
   Caption         =   "Adjust Sketch Dimensions"
   ClientHeight    =   2070
   ClientLeft      =   2040
   ClientTop       =   2325
   ClientWidth     =   5850
   OleObjectBlob   =   "AdjustSKDims.frx":0000
End
Attribute VB_Name = "AdjustSKDims"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'    This is a part of the source code for Pro/DESKTOP.
'    Copyright (C) 1999-2002 Parametric Technology Corporation.
'    All rights reserved.

'   File:AdjustSKDims.frm
'
'   This tool allows users to verify design intent built into sketches and explore
'   design possibilities by sliding dimension values.  The dialog is modeless, and
'   users can work freely while the dialog is present and modify different dimension values.
'
'   In order to enable a modeless dialog, we only grab the helm when absolutely necessary,
'   when searching for selected dimensions or making modifications.
'
' Known Problem:
'   1. Only one dimension can be selected if the form is to update

' definitions for the dialog
Dim theVal As Double    ' this guy keeps track of the dimensional value we'll be modifying
Dim theOriginalVal As Double  ' and this is theVal's original value
Dim theValue As zValue  ' the zValue of the dimesion being modified
Dim theVariable As aVariable    'the variable itself
Dim theOldVariable As aVariable 'and a copy of it to detect changes

Dim dynamicUpdate As Boolean    'update design with every change
Dim lockChanges As Boolean  'a flag to prevent updates, used when modifying scrollbars
Dim IsActive As Boolean     'true when a valid dimension is selected

' reference placeholders
Const pause As Boolean = False 'use True for single-step replay
Dim app As ProDESKTOP
Dim graphicDoc As GraphicDocument
Dim des As aDesign
Dim sk As aSketch
Dim wp As aWorkplane
Dim modDimension As aVariable

Const ScrollScale As Integer = 10000 'this constant sets the minimum resolution of the slider (1/ScrollScale)

'   The following forms are the implementation called by the form and other interface routins
'   They handle initialization, modification, and querying

' GetObjects is called to check whether the selected dimension has been changed
Private Sub GetObjects()
    Dim theDimension As aConstraint 'the constraint object being modified
    
    Set graphicDoc = app.GetActiveDoc
    
    If TypeOf graphicDoc Is PartDocument Or TypeOf graphicDoc Is DrawingDocument Then
        Set sk = graphicDoc.GetActiveSketch
        Set wp = graphicDoc.GetActiveWorkplane
        Set theDimension = graphicDoc.GetSingleSelection("Constraint")
    
        If Not theDimension Is Nothing Then
            Set theVariable = theDimension.GetDefinition.GetVariable
            If (Not theVariable Is theOldVariable) Or (Not IsActive) Then
                Set theOldVariable = theVariable
                IsActive = True
                InitObjects
            End If
        End If
    End If
End Sub

Private Sub InitObjects() 'set up the sketch objects to allow dimensional modifications
    
    ScrollBar1.Enabled = IsActive       'if we've got a valid dimension, turn on the controls
    scrollBar1max.Enabled = IsActive
    scrollBar1min.Enabled = IsActive
    scrollBar1value.Enabled = IsActive
    DynamicUpdateBox.Enabled = IsActive
    Label_Value.Enabled = IsActive
    Label_max.Enabled = IsActive
    Label_min.Enabled = IsActive
    ScrollBar1ResetButton.Enabled = IsActive
    
    If IsActive Then                'initialize slider values and text
        theVal = GetModDimValue     'get the actual value of the dim
        theOriginalVal = theVal   'leave a default
        lockChanges = True     'don't do any updating while we're changing these, else they will trigger each other
        ScrollBar1.Min = 0.1 * theVal * ScrollScale 'set the extrema values
        ScrollBar1.Max = 2 * theVal * ScrollScale
        ScrollBar1.Value = theVal * ScrollScale   'and assign the slider
        lockChanges = False     'it's safe to unlock the dims now
        scrollBar1max.Text = 2 * theVal   'and their fields
        scrollBar1min.Text = 0.1 * theVal
        ScrollBar1.LargeChange = 10 ^ (Log(theVal) / Log(10) - 1) * ScrollScale 'set the large change value
        ScrollBar1.SmallChange = 10 ^ (Log(theVal) / Log(10) - 2) * ScrollScale 'set the large change value
        If Not ScrollBar1Frame.Caption = GetModDimName Then ScrollBar1Frame.Caption = GetModDimName 'the reason we use the if statement is to keep it from flashing
    Else    'if there's no selected dimension
        If Not ScrollBar1Frame.Caption = GetResourceString(351) Then ScrollBar1Frame.Caption = GetResourceString(351) 'the reason we use the if statement is to keep it from flashing
    End If
End Sub

' this guy changes the value of the dimension
Private Sub SetModDimValue(theVal As Double)
    Dim api As helm
    On Error GoTo errorHandler
    Set api = app.TakeHelm
    
    theValue.SetUserValue theVal    'SetUserValue converts the user units to system units
    theVariable.SetValue theValue
    
    api.CommitCalls "Modify Slider Dimension", pause
    If dynamicUpdate Then   'this is called when the we want to rebuild the part, not just the sketch
        If TypeOf graphicDoc Is PartDocument Then
            graphicDoc.UpdateDesign
        End If
        api.CommitCalls "Update", pause
    End If
    
errorHandler:
  If Err.Number = 13 Then
    MsgBox GetResourceString(352)
  End If
End Sub

Private Function GetModDimValue() As Double
    Set theValue = theVariable.GetValue
    GetModDimValue = theValue.GetUserValue
End Function

Private Function GetModDimName() As String
    GetModDimName = theVariable.GetName
End Function

' Detect reentry into the form and call for an update
    
Private Sub ScrollBar1Frame_MouseMove(ByVal Button As Integer, ByVal Shift As Integer, ByVal x As Single, ByVal Y As Single)
    GetObjects
End Sub

Private Sub UserForm_Initialize()
    Me.OKButton.Caption = GetResourceString(91)
    Me.CancelButton.Caption = GetResourceString(92)
    Me.ScrollBar1ResetButton.Caption = GetResourceString(93)
    Me.UpdateButton.Caption = GetResourceString(94)
    Me.Label_min.Caption = GetResourceString(353)
    Me.Label_Value = GetResourceString(354)
    Me.Label_max.Caption = GetResourceString(355)
    Me.DynamicUpdateBox.Caption = GetResourceString(356)
    Me.Caption = GetResourceString(357)
End Sub

Private Sub UserForm_MouseMove(ByVal Button As Integer, ByVal Shift As Integer, ByVal x As Single, ByVal Y As Single)
    GetObjects
End Sub

' Form definiton routines
' These routines handle all messages sent from the form

Private Sub UserForm_Activate() 'called when the form is loaded

    On Error GoTo errorHandler
    Set app = CreateObject("ProDESKTOP.Application")
    Dim api As helm
    On Error GoTo errorHandler
    Set api = app.TakeHelm
    app.SetVisible True
    dynamicUpdate = False
    IsActive = False
    InitObjects 'deactivate the controls if no dimension is selected
    GetObjects 'initialize global variables
    On Error GoTo 0
Exit Sub

errorHandler:
    MsgBox GetResourceString(96)
    
End Sub

Private Sub CancelButton_Click()

    On Error GoTo errorHandler
    If IsActive Then
        dynamicUpdate = True
        SetModDimValue theOriginalVal   'restore the original value
    End If
    Hide
    On Error GoTo 0
    
Exit Sub

errorHandler:
    MsgBox GetResourceString(96)
    
End Sub

Private Sub OKButton_Click()

    Hide
    
End Sub

Private Sub UpdateButton_Click()    'update for changes made without dynamic update

    On Error GoTo errorHandler
    Dim api As helm
    Set api = app.TakeHelm
    If TypeOf graphicDoc Is PartDocument Then
        graphicDoc.UpdateDesign
    End If
    api.CommitCalls "Update", pause
    On Error GoTo 0
    
Exit Sub

errorHandler:
    If Err.Number = 13 Then 'error code 13 represents type mismatch
        MsgBox GetResourceString(352)
    Else
        MsgBox GetResourceString(96)
    End If
    
End Sub

Private Sub DynamicUpdateBox_Click()

    On Error GoTo errorHandler
    dynamicUpdate = DynamicUpdateBox.Value
    SetModDimValue theVal   'make sure it updates for any changes made
    On Error GoTo 0
    
Exit Sub

errorHandler:
        MsgBox GetResourceString(96)
        
End Sub

Private Sub ScrollBar1ResetButton_Click()

    On Error GoTo errorHandler
    If IsActive Then
        SetModDimValue theOriginalVal   'rebuild to the original value
        theVal = theOriginalVal         'and the real value
        InitObjects                     'and put the sliders back too
    End If
    On Error GoTo 0
    
Exit Sub

errorHandler:
    MsgBox GetResourceString(96)
    
End Sub

Private Sub ScrollBar1_Change() 'whenever there's a change to the value
    If Not lockChanges Then theVal = ScrollBar1.Value / ScrollScale 'update the value
    SetModDimValue theVal               'and update the sketch
    scrollBar1value.Text = theVal   'and the text field
End Sub

Private Sub ScrollBar1_Scroll() 'same as ScrollBar1_Change()
    ScrollBar1_Change
End Sub

'These routines handle changes to the extrema text fields.
'If a minimum is chosen that's greater than the maximum, the minimum becomes the old maximum, and vice-versa

Private Sub scrollBar1max_exit(ByVal Cancel As MSForms.ReturnBoolean)
    
    On Error GoTo errorHandler
    Dim newValue As Double
    newValue = scrollBar1max.Text
    If (newValue * ScrollScale < ScrollBar1.Min) Then
        ScrollBar1.Max = ScrollBar1.Min
        scrollBar1max.Text = scrollBar1min.Text
        ScrollBar1.Min = newValue * ScrollScale
        ScrollBar1.Value = newValue * ScrollScale
        scrollBar1min.Text = newValue
    Else
        ScrollBar1.Max = newValue * ScrollScale
    End If
    On Error GoTo 0
Exit Sub

errorHandler:
    If Err.Number = 13 Then 'error code 13 represents type mismatch
        MsgBox GetResourceString(352)
    Else
        MsgBox GetResourceString(96)
    End If
    
End Sub

Private Sub scrollBar1min_exit(ByVal Cancel As MSForms.ReturnBoolean)

    On Error GoTo errorHandler
    Dim newValue As Double
    newValue = scrollBar1min.Text
    If (newValue * ScrollScale > ScrollBar1.Max) Then
        ScrollBar1.Min = ScrollBar1.Max
        scrollBar1min.Text = scrollBar1max.Text
        ScrollBar1.Max = newValue * ScrollScale
        ScrollBar1.Value = newValue * ScrollScale
        scrollBar1max.Text = newValue
    Else
        ScrollBar1.Min = newValue * ScrollScale
    End If
    On Error GoTo 0
Exit Sub
    
errorHandler:
    If Err.Number = 13 Then     'error code 13 represents type mismatch
        MsgBox GetResourceString(352)
    Else
        MsgBox GetResourceString(96)
    End If
    
End Sub

Private Sub scrollBar1value_Change()    'change the scrollbar to a text field modification
    
    On Error GoTo errorHandler
    Dim newValue As Double
    If Not (scrollBar1value.Text = "") Then
        newValue = scrollBar1value.Text * ScrollScale
        If (newValue > ScrollBar1.Min) And (newValue < ScrollBar1.Max) Then 'only allow values in bounds
            ScrollBar1.Value = newValue
            ScrollBar1.Value = newValue
        End If
    End If
    On Error GoTo 0
Exit Sub

errorHandler:
    MsgBox GetResourceString(96)
    
End Sub
